/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "HandlerPackager.h"

HandlerPackager::HandlerPackager () { }

HandlerPackager::~HandlerPackager () { }

char * HandlerPackager::buildPackage(hndPackage* hpack, int len, int& nlen) {

    char *msg = NULL;

    nlen = HEAD_HP_SIZE + len;
    msg = new char[nlen];
    msg[0] = (((unsigned char) hpack->hnd) << 3) | ((unsigned char) hpack->oper); //Handler + Oper
    msg[1] = (unsigned char) nlen; // largo del paquete
    msg[2] = (unsigned char) 0; // reservado.
    for (int i=0 ; i < len; i++) {
        msg[i+HEAD_HP_SIZE] = hpack->data[i];
    }
    return msg;
}

hndPackage* HandlerPackager::unbuildPackage(char *msg, int len) {

    hndPackageResponse *hpackres;
    hndPackage *hpack = NULL;

    if (len > 0) {
        hpackres = (hndPackageResponse*) msg;
        hpack = new hndPackage();
        hpack->hnd = hpackres->hnd;
        hpack->oper = (operation) hpackres->oper;
        for (int i=0; i<len-HEAD_HP_SIZE; i++) {
            hpack->data[i] = hpackres->data[i];
        }
    }
    return hpack;
}
